package android.reader;


import android.util.Log;


import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.reader.R;
import android.reader.Application;
import android.app.Activity;
//import android.content.Intent;

public class CardOperate extends Activity {
	EditText mReception;
	private ArrayAdapter<String> adapter;
    private List<String> allItems; 
    protected Application mApplication;
    protected ReaderAndroid mSerialPort;
    protected int handle;
    protected int address=0x00;
    protected byte mode=0x00, hald_flag=0x00;
    protected byte[] card_flag=new byte[1];
    
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.cardoperate);
		
		Spinner block=(Spinner)findViewById(R.id.spBlock);
 		block.setVisibility(View.VISIBLE);
 		allItems = new ArrayList<String>(); 
 		for(int i=0;i<64;i++)
 		{
 			allItems.add(i, String.valueOf(i)); 		
 		}
 		          
 		adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, allItems); 
 		adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item); 
 		block.setAdapter(adapter); 		
 		
 		Spinner block_w =(Spinner)findViewById(R.id.spBlock_W);
 		block_w.setVisibility(View.VISIBLE); 
 		block_w.setAdapter(adapter);
 		block_w.setSelection(1);
 		
 		mReception = (EditText) findViewById(R.id.EditTextReception);
				
		((Button)findViewById(R.id.btnClear)).setOnClickListener(btnOnClick);
		((Button)findViewById(R.id.btnReadCard)).setOnClickListener(btnOnClick);
		((Button)findViewById(R.id.btnWriteCard)).setOnClickListener(btnOnClick);
		
		mApplication = (Application) getApplication();
		try {
			mSerialPort = mApplication.getSerialPort();
			Log.i("ANDROID", "getSerialPort end");
			handle = mSerialPort.getHandle();
			Log.i("ANDROID", "mSerialPort.getHandle()");

		} catch (SecurityException e) {
			DisplayError(R.string.error_security);
		} catch (IOException e) {
			DisplayError(R.string.error_unknown);
		} catch (InvalidParameterException e) {
			DisplayError(R.string.error_configuration);
		}
	}

	private void DisplayError(int errorSecurity) {
		// TODO Auto-generated method stub	
	}

	private CbtnOnClick btnOnClick = new CbtnOnClick();
	
	private class CbtnOnClick implements View.OnClickListener {	
    	@Override   
        public void onClick(View v){
			byte[] value=new byte[]{(byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF,
                    (byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF,
                    (byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF,
                    (byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF};
			byte[] bPWS=new byte[]{(byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF};
			String sPWS=new String("");
			byte[] ver=new byte[20];
			byte mblock;

			switch (v.getId()) { 
			case R.id.btnReadCard:
				mblock = (byte)((((Spinner)findViewById(R.id.spBlock)).getLastVisiblePosition())&0xff);
				sPWS = ((EditText)findViewById(R.id.edit_PWS_R)).getText().toString();
				if(strToByte(sPWS,6,bPWS)!=0)
				{
					 mReception.append(getString(R.string.error_LengthofPWS).toString());					 
					 return ;				
				}
				
				if(0 == mSerialPort.MFRead(handle, address, mode, mblock, (byte)(0x01 & 0xff), bPWS, ver))
				{
					mReception.append("from "+ByteToStr(4, bPWS)+"  \ncard Read data:\n"+ByteToStr(16, ver)+"\n");			
				}
				else
				{
					mReception.append("Read card  error\n");
				}
				break;
			case R.id.btnWriteCard:				
				mblock = (byte)((((Spinner)findViewById(R.id.spBlock_W)).getLastVisiblePosition())&0xff);
				sPWS = ((EditText)findViewById(R.id.edit_PWS_W)).getText().toString();
				String wrData = ((EditText)findViewById(R.id.edit_Value)).getText().toString();
				if(strToByte(sPWS, 6, bPWS) != 0)
				{
					mReception.append(getString(R.string.error_LengthofPWS).toString());						 
					return ;				
				}				
				try {				
					if(strToByte(wrData,16,value) != 0) 
					{
					  mReception.append(getString(R.string.error_lengthOfValue).toString());					 			
					  return ;
					}
				}
				finally {
					Log.d("Eebug-ANDROID", "strToByte error");	
				}
				
				if(0==mSerialPort.MFWrite(handle, address, mode, mblock, (byte)(0x01 & 0xff), bPWS, value))
				{
					mReception.append("Write card:"+ByteToStr(bPWS[0], value)+"\n");
				}
				else
				{
					mReception.append("Write card  error\n");
				}
				break;
			case R.id.btnClear:
				mReception.setText("");
				break;
			}		
		}	
	} 

	public  int  strToByte(String in,int byteSize,byte[] out)
	{
		String str=in.replace(" ", "");
		if(str.length()!=byteSize*2 || out==null)
		{
			return -1;
		}  	      
		char[] hexChars = str.toCharArray(); 
		if(hexChars==null)
		{
			return -1;
		}  
		for (int i = 0; i < byteSize; i++) {   
			int pos = i * 2;   
			out[i] = (byte) ((charToByte(hexChars[pos]) << 4 )| (charToByte(hexChars[pos + 1])));   
		} 
		return 0;	
	}
	
	private int charToByte(char c) {   
        return  "0123456789ABCDEF".indexOf(c);   
    }
	
	public  String  ByteToStr(int byteSize,byte[] in)
    {
   	 String ret=new String("");    	 
   	 if(in.length<byteSize)
   		 return ret;
   	 
   	 for(int i=0;i<byteSize;i++)
   	 {
   		 ret=ret.concat(String.format("%1$02X ", in[i]));
   	 }
   	 return ret;   
    }
}